/**
 * Beschrijft een strijderspersonage van een computergame.
 * 
 * @author Dominiek Vandewalle 
 * @version 2015-04-15
 */
public class Strijder
{
    private String naam;
    private int aantalLevens;
    private int gezondheid;
    
    /**
     * Constructor voor objecten van de klasse Strijder.
     * @param   naam    De naam van de strijder.
     */
    public Strijder(String naam)
    {
        this.naam = naam;
        aantalLevens = 3;
        gezondheid = 100;
    }
    
    /**
     * Schiet op een andere strijder.
     * @param   tegenstander    De strijder die beschoten wordt
     */
    public void schiet(Strijder tegenstander)
    {
        if(gezondheid > 0)
        {
           tegenstander.geraakt();
        }  
    }
    
    /**
     * Vermindert de gezondheidstoestand van de strijder met 40 procent. 
     * De strijder verliest een leven indien de gezondheidstoestand op nul staat 
     * en de strijder nog levens heeft.
     */
    public void geraakt()
    {
        gezondheid = Math.max(0, gezondheid - 40);
        
        if(gezondheid == 0 && aantalLevens > 0)
        {
            aantalLevens--;
            gezondheid = 100;
        }
    }
    
    /**
     * Toont de gezondheidsstatus van de strijder in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
        System.out.println("Gezondheid: " + gezondheid);
    }
}